% This function use DAPI to divide cells into different cell cycle stages
function [statTab, ResultTable] = cellCycleGroup(ResultTable, vis)
chDNA = 3; chSE = 2; chIF = 1; %chIF->AHA
statTab = unique(ResultTable(:, {'Well','Condition'}));
CellNum = ones(size(statTab,1), 2)*nan; % 1st col raw number, 2nd col cleaned number
Props = ones(size(statTab,1), 3)*nan; % G1, S, G2
MedianSize = ones(size(statTab,1), 4)*nan; % average, G1, S, G2, G1(EG1+LG1)
DNA2N = ones(size(statTab,1),1)*nan; % DAPI level for 2N
NucArea = ones(size(statTab,1), 4)*nan; % average, G1, S, G2, G1(EG1+LG1)
sizeMAD = ones(size(statTab,1), 4)*nan; % average, G1, S, G2, G1(EG1+LG1)
MedianIF = ones(size(statTab,1), 4)*nan; % average, G1, S, G2, G1(EG1+LG1)
idxcc = zeros(size(ResultTable,1),1); % record cell cycle stages for each cell

DNAall = ResultTable.NInt(:,chDNA);
temp = prctile(ResultTable.NInt(:,chDNA), [.5 99.5]);
spanDNA = linspace(temp(1),temp(2),1e3);
for kk = 1:size(statTab,1)
    idxwell = ResultTable.Well==statTab.Well(kk);
    Cells = ResultTable(idxwell,:);
    if size(Cells, 1)<200; continue; end % no cell data
    DNA = Cells.NInt(:,chDNA);
    Size = Cells.CInt(:,chSE);
    N_Area = Cells.NArea;
    IF = Cells.CInt(:,chIF);
   % Set adaptive thresholds for DNA
    [fi,xi] = ksdensity(DNA,spanDNA);
    xi = xi(fi>max(fi)/5); fi = fi(fi>max(fi)/5);
     [~,loc] = findpeaks(fi); 
     if length(loc)==1
         pk1DNA = xi(loc);   
     elseif length(loc)>=2
         pk1DNA = xi(min(loc));
     else
         continue;
     end
%     pk1DNA = xi(fi==max(fi));  % DNA level of 2N peak
%     [fi,xi] = ksdensity(DNA, 0.5*pk1DNA:0.02*pk1DNA:2.5*pk1DNA);
%     pk1DNA = xi(fi==max(fi));
    DNA2N(kk)=pk1DNA;
    %pk2DNA = xi(fi==max(fi(xi>1.7*pk1DNA)));
    DNA_thr1 = 0.85*pk1DNA;
    DNA_thr2 = 1.1*pk1DNA;
    DNA_thr3 = 1.9*pk1DNA;
    DNA_thr4 = 2.3*pk1DNA;
    % Index for different cell cycle groups
    idxG1 = DNA>DNA_thr1 & DNA<DNA_thr2*1.05;
    idxS = DNA>DNA_thr2 & DNA<DNA_thr3;
    idxG2 = DNA>DNA_thr3 & DNA<DNA_thr4;
    idxAll = idxG1|idxS|idxG2;
    
    % assign cell cycle stage
    idxcc(idxwell&DNAall>DNA_thr1 & DNAall<DNA_thr2*1.05)=1;
    idxcc(idxwell&DNAall>DNA_thr2 & DNAall<DNA_thr3)=2;
    idxcc(idxwell&DNAall>DNA_thr3 & DNAall<DNA_thr4)=3;
    
    % Calculate
    CellNum(kk,1) = size(Cells, 1); % raw cell number
    CellNum(kk,2) = sum(idxAll); % corrected cell number (within reasonable DNA level)
    Props(kk,:) = [sum(idxG1) sum(idxS) sum(idxG2)] /sum(idxAll) ; % G1, S, G2
    MedianSize(kk,:) = [median(Size(idxAll)) median(Size(idxG1)) median(Size(idxS)) median(Size(idxG2))]; % average, G1, S, G2  
    NucArea(kk,:) = [median(N_Area(idxAll)) median(N_Area(idxG1)) median(N_Area(idxS)) median(N_Area(idxG2))]; % average, G1, S, G2      
    sizeMAD(kk,:) = [mad(Size(idxAll),1) mad(Size(idxG1),1) mad(Size(idxS),1) mad(Size(idxG2),1)]; % average, G1, S, G2  
    MedianIF(kk,:) = [median(IF(idxAll)) median(IF(idxG1)) median(IF(idxS)) median(IF(idxG2))]; % average, G1, S, G2  
    DNA2N(kk) = pk1DNA;
    
    % Visualization
    if vis==1
        figure(100); histogram(DNA,linspace(DNA_thr1,DNA_thr4,100)); hold on; 
        plot([1 2; 1 2]*pk1DNA, [0 1000]', 'k--'); %2N DNA
        plot([1; 1]*[DNA_thr1, DNA_thr2, DNA_thr3, DNA_thr4], [0 1000]', 'k'); %thr
        title(['Well: ' int2str(statTab.Well(kk))])
        set(gca, 'FontSize', 12); xlabel('DNA'); ylabel('Count');
        xlim([.8*DNA_thr1 DNA_thr4*1.3]); 
        hold off; pause(.2);
    end
end
ResultTable.idxcc = idxcc;
statTab = [statTab, table(CellNum, Props, MedianSize, NucArea, sizeMAD, MedianIF, DNA2N)];
